#include <allegro.h>

#include "actor.h"
#include "draw.h"
#include "sectors.h"
#include "man.h"
#include "alienship.h"
#include "tree.h"

float tree_points[] = {
	    -3.000,     -1.000, // 0
	    -8.000,     55.000, // 1
	     5.000,     -1.000, // 2
	     5.000,     58.000, // 3
	   -79.000,    117.000, // 4
	    62.000,    137.000, // 5
	     4.000,     67.000, // 6
	     0.000,     62.000, // 7
	   -32.000,    180.000, // 8
	    -7.000,    111.000, // 9
	     0.000,     92.000, // 10
	    17.000,    170.000, // 11
	   -45.000,     49.000, // 12
	    29.000,     44.000, // 13
	   -52.000,    145.000, // 14
	    37.000,    134.000  // 15
};
int tree_lines[] = {
	0, 1, 160, 104, 0,
	2, 3, 160, 104, 0,
	1, 4, 160, 104, 0,
	3, 5, 160, 104, 0,
	6, 5, 160, 104, 0,
	7, 4, 160, 104, 0,
	7, 8, 160, 104, 0,
	10, 6, 160, 104, 0,
	11, 9, 160, 104, 0,
	11, 10, 160, 104, 0,
	9, 8, 160, 104, 0,
	4, 8, 44, 180, 0,
	8, 11, 44, 180, 0,
	11, 5, 44, 180, 0,
	6, 11, 44, 180, 0,
	12, 4, 44, 180, 0,
	13, 5, 44, 180, 0,
	12, 1, 172, 116, 0,
	3, 13, 172, 116, 0,
	7, 14, 44, 152, 0,
	7, 15, 44, 152, 0
};
float treedie1_points[] = {
	    -2.877,      1.313, // 0
	    31.632,     45.699, // 1
	     2.977,     -4.140, // 2
	    43.190,     39.034, // 3
	    19.000,    137.000, // 4
	   138.744,     57.992, // 5
	    49.000,     45.000, // 6
	    39.000,     49.000, // 7
	    90.000,    148.000, // 8
	    70.532,     85.995, // 9
	    62.705,     67.321, // 10
	   122.000,    116.000, // 11
	     0.468,     66.527, // 12
	    46.000,     10.000, // 13
	    55.000,    139.000, // 14
	   119.000,     69.000  // 15
};
int treedie1_lines[] = {
	0, 1, 0, 0, 0,
	2, 3, 0, 0, 0,
	1, 4, 0, 0, 0,
	3, 5, 0, 0, 0,
	6, 5, 0, 0, 0,
	7, 4, 0, 0, 0,
	7, 8, 0, 0, 0,
	10, 6, 0, 0, 0,
	11, 9, 0, 0, 0,
	11, 10, 0, 0, 0,
	9, 8, 0, 0, 0,
	4, 8, 0, 0, 0,
	8, 11, 0, 0, 0,
	11, 5, 0, 0, 0,
	6, 11, 0, 0, 0,
	12, 4, 0, 0, 0,
	13, 5, 0, 0, 0,
	12, 1, 0, 0, 0,
	3, 13, 0, 0, 0,
	7, 14, 0, 0, 0,
	7, 15, 0, 0, 0,
};
float treedie2_points[] = {
	    -1.351,      2.859, // 0
	    53.652,     14.508, // 1
	    -0.396,     -5.084, // 2
	    58.182,      1.960, // 3
	   139.000,     28.000, // 4
	   154.000,     -8.000, // 5
	    66.998,      4.027, // 6
	    61.557,      7.401, // 7
	   173.000,     10.000, // 8
	   113.000,      5.000, // 9
	    93.000,      4.000, // 10
	   171.000,     -8.000, // 11
	    27.000,     21.000, // 12
	    42.000,     -7.000, // 13
	   148.000,     18.000, // 14
	   143.000,     -5.000  // 15
};
int treedie2_lines[] = {
	0, 1, 0, 0, 0,
	2, 3, 0, 0, 0,
	1, 4, 0, 0, 0,
	3, 5, 0, 0, 0,
	6, 5, 0, 0, 0,
	7, 4, 0, 0, 0,
	7, 8, 0, 0, 0,
	10, 6, 0, 0, 0,
	11, 9, 0, 0, 0,
	11, 10, 0, 0, 0,
	9, 8, 0, 0, 0,
	4, 8, 0, 0, 0,
	8, 11, 0, 0, 0,
	11, 5, 0, 0, 0,
	6, 11, 0, 0, 0,
	12, 4, 0, 0, 0,
	13, 5, 0, 0, 0,
	12, 1, 0, 0, 0,
	3, 13, 0, 0, 0,
	7, 14, 0, 0, 0,
	7, 15, 0, 0, 0,
};


void tree_process(int num)
{
	int remove = 0;
	ACTOR *actor = man[num];
	
	{
		float d = actor->x - alienship.x;
		if (d > SECTORS * SECTOR_DIMENSION / 2) {
			d -= SECTORS * SECTOR_DIMENSION;
		}
		if (d < -SECTORS * SECTOR_DIMENSION / 2) {
			d += SECTORS * SECTOR_DIMENSION;
		}
		if ( d > 3000 || d < -3000) {
			if (sector_place_man(actor)) remove = 1;
		}
	}
	
	if (actor->hit) {
		actor->anim++;
		if (actor->anim == 16) {
			actor->anim = 0;
			actor->frame++;
			if (actor->frame == 4) actor->frame = 3;
		}
	}
	
	if (remove) {
		mans_num--;
		if (mans_num > 0) {
			man[num] = man[mans_num];
			man_process(num);
		}
	}
}

static void tree_draw(ACTOR *actor, int x, int y)
{
	if (actor->dx > 0) {
		if (actor->frame == 0) draw_(x, y, points(tree), lines(tree), tree_points, tree_points, tree_lines, actor->anim / 16.0);
		if (actor->frame == 1) draw_(x, y, points(tree), lines(tree), tree_points, treedie1_points, tree_lines, actor->anim / 16.0);
		if (actor->frame == 2) draw_(x, y, points(treedie1), lines(treedie1), treedie1_points, treedie2_points, treedie1_lines, actor->anim / 16.0);
		if (actor->frame == 3) draw_(x, y, points(treedie2), lines(treedie2), treedie2_points, treedie2_points, treedie2_lines, actor->anim / 16.0);
	}
	if (actor->dx < 0) {
		if (actor->frame == 0) m_draw_(x, y, points(tree), lines(tree), tree_points, tree_points, tree_lines, actor->anim / 16.0);
		if (actor->frame == 1) m_draw_(x, y, points(tree), lines(tree), tree_points, treedie1_points, tree_lines, actor->anim / 16.0);
		if (actor->frame == 2) m_draw_(x, y, points(treedie1), lines(treedie1), treedie1_points, treedie2_points, treedie1_lines, actor->anim / 16.0);
		if (actor->frame == 3) m_draw_(x, y, points(treedie2), lines(treedie2), treedie2_points, treedie2_points, treedie2_lines, actor->anim / 16.0);
	}
}

ACTOR *tree_init(void)
{
	static int gotcolor = 0;
	ACTOR *actor;
	if (mans_total == TOTAL_MANS) return NULL;
	actor = &(all_mans[mans_total]);
	actor_init(actor);
	bound_(points(tree), tree_points, &actor->l, &actor->t, &actor->r, &actor->b);
	if (!gotcolor) {
		color_(lines(tree), tree_lines);
		gotcolor = 1;
	}
	actor->draw = tree_draw;
	
	if ((rand() >> 8) & 1) actor->dx = 1; else {
		float t = actor->l;
		actor->dx = -1;
		actor->l = -actor->r;
		actor->r = -t;
	}
	
	actor->type = 1;
	
	mans_total++;
	return actor;
}
